# Ceiling shower

Professor Oak is reforming his flat. He asks for a ceiling shower
(consider it a point) in the middle of a $140 \times 90$ rectangular
space. The start of the water pipe (a straigh line) must be located at a
corner of the rectangle. Instead of using the Pythagoras' theorem and
cutting a pipe of length $\sqrt{70^2 + 45^2} \simeq 83.22$, the plumber
arbitrarily decides to cut a pipe of length 75. Therefore, the shower
cannot be placed in the middle of the rectangle, so the goal is to
minimize the uglyness of the shower, defined as the Manhattan distance
between the shower and the center of the rectangle.

0.45 The picture to the right corresponds to the example above. The
black line is the ideal pipe of length 83.21..., from $(0, 0)$ to
$(70, 45)$. The red line shows the optimal placement with a pipe of
length 75, which goes from $(0, 0)$ to $(60, 45)$, with an uglyness of
$\vert 60 - 70 \vert + \vert 45 - 45 \vert = 10 + 0 = 10$.

0.6

::: pspicture
(14,9)

(0,0)(14,0)(14,9)(0,9)

(0,0)(7,4.5)

(0,0)(6,4.5)
:::

Can you help Prof. Oak to minimize the uglyness? He is so desperate with
the reform of his flat that he does not even require the shower to be
inside the rectangle.

## Input

Input consists of several cases, each one with three strictly positive
real numbers $h$, $v$ and $\ell$, corresponding to the dimensions
$h \times v$ of the rectangle and the length $\ell$ of the pipe.

## Output

For each case, print the minimum possible uglyness with four digits
after the decimal point. To do so, include these two lines at the
beginning of your main:

        cout.setf(ios::fixed);
        cout.precision(4);

The input cases do not have precision issues.

## Problem information

Author: Salvador Roura

Generation: 2026-01-25T10:30:11.011Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
