# Encuestas UPC

La UPC necesita un programa para procesar las encuestas de satisfacción
que responden los estudiantes. El programa debe leer a la entrada todas
las encuestas de todas las asignaturas y producir un listado ordenado de
los resultados para cada asignatura.

El número $n$ de preguntas para cada encuesta se indica al principio,
con $3 \leq n \leq 20$. Cada encuesta $e$ tiene el código de la
asignatura y las respuestas a las $n$ preguntas de la encuesta, que son
valores numéricos $e_i$, $1 \leq i \leq n$ con $0 \leq e_i \leq 5$. El
resultado para cada asignatura es la lista de las medias de los valores
de cada pregunta de la encuesta.

Para calcular la media de forma más fiable estadísticamente, no se
tienen en cuenta para el cálculo la encuesta con mejor resultado y la
encuesta con peor resultado, porque se asume que ambos extremos son
encuestas con sesgo. Solo se quita una sola encuesta de cada extremo,
aunque haya más de una encuesta con peor o mejor resultado. No obstante,
esta corrección solo se aplica cuando la cantidad de encuestas
disponible para una asignatura es mayor o igual a 5, para remediar la
escasez de muestras.

**Comparación de dos encuestas**: una encuesta $a$ con valores $a_i$ es
mayor que otra encuesta $b$ con valores $b_i$ si la suma
$s_a = \sum_{i} a_i$ es mayor que la suma $s_b = \sum_{i} b_i$.

## Entrada

La entrada empieza con un natural $n$, el número de preguntas de cada
encuesta. Luego viene un natural positivo $m$, que es el número total de
encuestas. A continuación vienen las encuestas, cada una con un código
(un natural) y los valores $e_i$, $1 \leq i \leq n$, con
$1 \leq e_i \leq 5$. Las encuestas tienen un orden aleatorio.

## Salida

La salida es una lista de los resultados, ordenados por código de
asignatura, donde cada resultado contiene el código de la asignatura,
seguido por las $n$ medias de cada pregunta de la encuesta. Los
resultados deben tener exactamente dos decimales.

## Observación

Recordada que podeis escribir un real `x` con dos decimales con el
comando `print(f"{x:.2f}")`.

## Información del problema

Autoría: PRO1

Generación: 2026-01-25T10:28:44.248Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
