# Conjunt de Mandelbrot

Donats dos nombres complexos $c$ i $z$, sigui $f_c(z) = z^2 + c$. Donat
un complex $c$, considereu la seqüència infinita
$f_c(0), f_c(f_c(0)), \dots$ Per definició, el conjunt de Mandelbrot
està compost pels valors de $c$ tals que la seva seqüència infinita està
afitada en valor absolut. Per exemple, amb $c = -2$ obtenim
$-2, 2, 2, 2, \dots$, la qual està afitada. En canvi, amb $c = 1$
obtenim $1, 2, 5, 26, \dots$, la qual tendeix a infinit. Per tant, $-2$
pertany al conjunt però 1 no.

Sigui $c = x + yi$, i sigui $q(c) = x^2 + y^2$. En general, donat un
$c$, no és senzill determinar si pertany al conjunt. Però se sap que cap
$c$ tal que $q(c) > 4$ hi pertany. Així que aquí usarem una aproximació
molt usual: Per a cada punt $c$ en qüestió, anirem comprovant que
$q(c) \le 4$, que $q(f_c(0)) \le 4$, que $q(f_c(f_c(0))) \le 4$, com a
molt $k$ vegades. Si, en algun moment, la condició no es compleix,
sabrem segur que el nombre no pertany al conjunt. Altrament, si la
condició es compleix $k$ vegades, suposarem que sí que hi pertany. Com
mes gran sigui $k$, menys errors cometrà el programa, però a canvi més
temps trigarà.

Feu un programa que dibuixi una zona del conjunt de Mandelbrot amb dos
colors: un per als punts de dins del conjunt i l'altre per als de fora
del conjunt.

## Entrada

L'entrada consisteix en dos noms de colors $c_1$ i $c_2$, seguits de sis
enters $x_1$, $x_2$, $y_1$, $y_2$, $e$, i $k$. Suposeu $x_1 < x_2$,
$y_1 < y_2$, $e \ge 1$, i $k \ge 1$.

## Sortida

Genereu una imatge $(x_2 - x_1 + 1, y_2 - y_1 + 1)$. El paràmetre $e$
indica l'escalat de la imatge: Les $x$ a considerar són
$x_1/e, (x_1 + 1)/e, \dots, (x_2 - 1)/e$, i $x_2/e$, i de forma similar
amb les $y$. (Com a mostra, el primer exemple d'entrada té les $x$ entre
$-1.5$ i $0.7$, i les $y$ entre $-1$ i $1$, ambdues dimensions amb
increments de $0.01$.) Per a cada punt $p = (x, y)$, comenceu en
$c = x + yi$. Si es compleix la condició mencionada anteriorment $k$
vegades, llavors cal pintar el punt $p$ de color $c_1$; altrament de
color $c_2$.

## Observacions

- Recordeu que $(\alpha + \beta i) + (\gamma + \delta i)
  = (\alpha + \gamma) + (\beta + \delta) i$.

- Recordeu que $(\alpha + \beta i) \cdot (\gamma + \delta i)
  = (\alpha \cdot \gamma - \beta \cdot \delta)
  + (\beta \cdot \gamma + \alpha \cdot \delta) i$.

- Els càlculs per fer aquest dibuixos són costosos. Per això els
  paràmetres dels jocs de proves són moderadament grossos. Proveu
  d'executar el vostre programa amb més punts de resolució i una $k$ més
  grossa per obtenir imatges més precises.

## Informació del problema

Autoria: Salvador Roura

Generació: 2026-01-25T10:25:58.978Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
