# Intercambio de árboles

Para resolver este problema, recordad que un árbol binario es o bien un
árbol vacío, o bien consiste en una raíz y dos subárboles binarios
(izquierdo y derecho). El inorden de un árbol binario es una secuencia
vacía si el árbol es vacío, y si no es el inorden del subárbol
izquierdo, seguido de la raíz, seguida del inorden del subárbol derecho.
La altura de un árbol es la longitud del camino más largo desde la raíz
hasta cualquier hoja. Un árbol AVL es un árbol binario que es o bien
vacío, o bien es tal que sus dos subárboles son AVL, y la diferencia de
altura entre ambos es como mucho 1. Una propiedad importante de los
árboles AVL es que su altura es logarítmica con respecto al número de
nodos.

Como muestra, estos son los tres árboles (iniciales) de los ejemplos de
entrada:
$$\pstree[levelsep=25pt,treesep=12pt]{\Tcircle{\mbox{\scriptsize 50}}}{
  \Tn
  \Tn
}
\qquad
\qquad
\pstree[levelsep=25pt,treesep=12pt]{\Tcircle{\mbox{\scriptsize 10}}}{
  \pstree{\Tcircle{\mbox{\scriptsize 20}}}
  {
    \Tn
    \Tn
  }
  \pstree{\Tcircle{\mbox{\scriptsize 40}}}
  {
    \Tn
    \Tn
  }
}
\qquad
\qquad
\pstree[levelsep=25pt,treesep=12pt]{\Tcircle{\mbox{\scriptsize 60}}}{
  \pstree{\Tcircle{\mbox{\scriptsize 30}}}
  {
    \Tn
    \pstree{\Tcircle{\mbox{\scriptsize 10}}}
    {
      \Tn
      \Tn
    }
  }
  \pstree{\Tcircle{\mbox{\scriptsize 20}}}
  {
    \pstree{\Tcircle{\mbox{\scriptsize 40}}}
    {
      \Tn
      \Tn
    }
    \pstree{\Tcircle{\mbox{\scriptsize 90}}}
    {
      \Tn
      \pstree{\Tcircle{\mbox{\scriptsize 20}}}
      {
        \Tn
        \Tn
      }
    }
  }
}
\vspace*{-0.5cm}$$

Vosotros debéis implementar eficientemente estas operaciones sobre un
árbol AVL:

- '`I`' $u$: Intercambia entre sí los subárboles izquierdo y derecho del
  nodo $u$.

- '`S`' $k$: Escribe la suma de los valores contenidos en los $k$
  primeros nodos en inorden del árbol actual, donde $0 \le k \le n$.

## Entrada

La entrada consiste en diversos casos. Cada caso empieza con el número
de nodos $n$ (entre 1 y $2^{17} - 1$) de un árbol AVL. Cada una de las
$n$ líneas siguientes describe al $i$-ésimo nodo con tres naturales que
indican el valor (entre 1 y 1000) contenido en el nodo, el nodo raíz del
subárbol izquierdo, y el nodo raíz del subárbol derecho. Los nodos se
numeran del 0 al $n-1$. Los subárboles vacíos se marcan con $-1$. La
raíz del árbol es siempre el nodo 0. Al final viene un natural $p$ entre
$n$ y $4n$, seguido de $p$ operaciones.

## Salida

Para cada operación de tipo '`S`', escribid la suma correspondiente.
Escribid una línea con 10 guiones al final de cada caso.

### Puntuación

- **Test-1:**   Entradas donde $n \le 20$, como el Ejemplo de entrada.

<!-- -->

- **Test-2:**   Entradas sólo con operaciones de tipo '`S`'.

<!-- -->

- **Test-3:**   Entradas de todo tipo.

## Información del problema

Autoría: Albert Martínez

Generación: 2026-01-25T10:25:46.006Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
