# Polynomials

Many polynomials can be written as the product of several factors, where
each one of them is itself a polynomial with integer coefficients. In
general, this decomposition can be made in many different ways. For
instance, $$2x^4 - 3x^3 + x^2 - 9x - 15
\enspace
=
\enspace
(x^3 + x^2 + 3x + 3)(2x - 5)
=
\enspace
(x^2 + 3)(x + 1)(2x - 5)
\enspace
.$$ Given two products of polynomials with integer coefficients, please
tell if they represent the same polynomial.

## Input

Input consists of several cases. Every case has two decompositions of a
polynomial, each on one line. The format is exactly as shown in the
sample input. The terms inside each factor are given in decreasing
order. The terms with coefficient zero are omitted. The degree of every
factor is at most 9. No factor is zero. The coefficients are not larger
than $10^9$ in absolute value. The represented polynomials have degrees
not larger than 1000, and coefficients not larger than $10^{100}$ in
absolute value.

## Output

For every case, print "`yes`" if the two polynomials are the same, or
"`no`" otherwise.

## Problem information

Author: Salvador Roura

Generation: 2026-01-25T10:24:10.312Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
