# Haskell --- Parcial 2019-11-06

# 1. Números romanos (con recursividad)

Define una función `roman2int :: String -> Int` que convierta un número
romano en su entero equivalente *usando recursividad*.

Recuerda que los números romanos se escriben con los símbolos `I`, `V`,
`X`, `L`, `C`, `D` y `M`, con valores 1, 5, 10, 50, 100, 500 y 1000
respectivamente. En este sistema, para obtener el número representado,
se suman los valores de los símbolos, excepto los símbolos situados a la
izquierda de un símbolo de valor mayor, que se restan.

# 2. Números romanos (sin recursividad)

Define una función `roman2int' :: String -> Int` que hace lo mismo que
la función anterior pero *sin usar recursividad*: usa una o más
funciones de orden superior.

# 3. Raíces

La serie de Taylor para calcular $\sqrt x$ es: $$\begin{align*}
    f_1(x)&=x \\
    f_n(x)&=\frac{1}{2}\left(f_{n-1}(x)+\frac{x}{f_{n-1}(x)}\right)
\end{align*}$$

Define una función `arrels :: Float -> [Float]` que, dado un real $x$,
retorna la lista infinita de los términos del desarrollo de Taylor de
$\sqrt x$.

# 4. Más raíces

Escribe una función `arrel :: Float -> Float -> Float` que a partir de
una $x$ y un $\epsilon$, aproxime la raíz de $x$ con un error inferior o
igual a $\epsilon$ utilizando la lista infinita anterior. El error en el
término $t_i$ de la serie (con $i>1$) es la diferencia en valor absoluto
entre $t_i$ y $t_{i-1}$.

# 5. Escritura de árboles

Considera el siguiente tipo genérico `LTree a` de árboles binarios con
valores en las hojas:

 `data LTree a = Leaf a ` Node (LTree a) (LTree a)\|

Haz que los árboles sean ("instance") de la clase `Show` visualizándolos
según los ejemplos.

# 6. Creación de árboles equilibrados

Haz una función `build :: [a] -> LTree a` que, dada una lista no vacía,
construye el `LTree` equilibrado (a la izquierda) que contiene los
elementos de la lista en el mismo orden de izquierda a derecha. Decimos
que un árbol está equilibrado a la izquierda si todos los subárboles
tienen el hijo izquierdo con la misma profundidad que el hijo derecho o
la misma más $1$.

# 7. Mónadas y árboles

Define una función
`zipLTrees :: LTree a -> LTree b -> Maybe (LTree (a,b))` que combine los
valores de las hojas de dos árboles con la misma estructura.

Si las estructuras de los dos árboles no encajan, retorna `Nothing` y,
si encajan, retorna `Just` del árbol que tiene en cada hoja el par con
el primer elemento del primer árbol y el segundo del segundo árbol en la
misma posición.

Utiliza la notación **do**.

## Información del problema

Autoría: Unknown\
Traducción: Albert Rubio

Generación: 2026-02-03T17:06:37.735Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
