# Haskell --- Parcial 2019-11-06

# 1. Nombres romans (amb recursivitat)

Definiu una funció `roman2int :: String -> Int` que converteixi un
número romà al seu enter equivalent *tot usant recursivitat*.

Recordeu que els números romans s'escriuen amb els símbols `I`, `V`,
`X`, `L`, `C`, `D` i `M`, amb valors 1, 5, 10, 50, 100, 500 i 1000
respectivament. En aquest sistema, per obtenir el nombre representat, se
sumen els valors dels símbols, excepte els símbols situats a l'esquerra
d'un símbol de valor més gran, que es resten.

# 2. Nombres romans (sense recursivitat)

Definiu una funció `roman2int' :: String -> Int` que faci el mateix que
la funció anterior però *sense usar recursivitat*: useu una o més
funcions d'ordre superior.

# 3. Arrels

La sèrie de Taylor per calcular $\sqrt x$ és: $$\begin{align*}
    f_1(x)&=x \\
    f_n(x)&=\frac{1}{2}\left(f_{n-1}(x)+\frac{x}{f_{n-1}(x)}\right)
\end{align*}$$

Definiu una funció `arrels :: Float -> [Float]` que, donat un real $x$,
retorni la llista infinita dels termes del desenvolupament de Taylor de
$\sqrt x$.

# 4. Més arrels

Escriviu una funció `arrel :: Float -> Float -> Float` que a partir
d'una $x$ i un $\epsilon$, aproximi l'arrel de $x$ amb un error inferior
o igual a $\epsilon$ utilitzant la llista infinita anterior. L'error en
el terme $t_i$ de la sèrie (amb $i>1$) és la diferència en valor absolut
entre $t_i$ i $t_{i-1}$.

# 5. Escriptura d'arbres

Considereu el següent tipus genèric `LTree a` d'arbres binaris amb
valors a les fulles:

 `data LTree a = Leaf a ` Node (LTree a) (LTree a)\|

Feu que els arbres siguin instàncies de la classe `Show` visualitzant-se
segons els exemples.

# 6. Creació d'arbres equilibrats

Feu una funció `build :: [a] -> LTree a` que, donada una llista no
buida, construeix el `LTree` equilibrat (a l'esquerra) que conté els
elements de la llista en el mateix ordre d'esquerra a dreta. Diem que un
arbre es equilibrat a l'esquerra si tots els subarbres tenen el fill
esquerre amb la mateixa profunditat que el fill dret o la mateixa més
$1$.

# 7. Mònades i arbres

Definiu una funció
`zipLTrees :: LTree a -> LTree b -> Maybe (LTree (a,b))` que combini els
valors de les fulles de dos arbres amb la mateixa estructura.

Si les estructures dels dos arbres no encaixen, retorna `Nothing` i, si
encaixen, retorna `Just` de l'arbre que té a cada fulla el parell amb el
primer element del primer arbre i el segon del segon arbre en la mateixa
posició.

Utilitzeu la notació **do**.

## Informació del problema

Autoria: Jordi Petit, Albert Rubio, Gerard Escudero

Generació: 2026-02-03T17:06:32.625Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
