# Fiscal Identification Number (NIF)

The Fiscal Identification Number (NIF in Spanish) is a unique code that
identifies to the Spanish citizens. NIF is a eight-figure number (that
form the National Document of Identity or DNI in Spanish) with a control
letter that is obtained from the number of DNI. This letter is used to
verify that the NIF has been correctly introduced. To obtained the NIF
letter, DNI modulo 23 must be computed. The result, a number between 0
and 22, is converted into a letter according to the following table:

::: NoShortVerb
   Remainder   ` 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22`
  ----------- ---------------------------------------------------------------
    Letter     ` T R W A G M Y F P D  X  B  N  J  Z  S  Q  V  H  L  C  K  E`

  : DNI letters
:::

The letters: I, Ñ, O, U are not used. Letter I may be confused with 1,
and letter O with 0.

The equivalent to DNI for foreigners is the Number od Identification of
Foreigners (NIF), a seven-figure numbers preceded by a X. The same
algorithm can be also used to the computation of the letter that
correspond to every NIF, rejecting the X and using the seven-figure
number.

Your task is to write a program that, for each given number of DNI or
NIF, computes the letters that corresponds it.

## Input

The input consists of a sequence of DNIs and NIFs. NIF starts with the
character X followed by a seven-figure number, while DNI is a
eight-figure number.

## Output

For each given number, your program must print a line with the letter
that corresponds to the DNI or the NIF.

## Problem information

Author: Unknown\
Translator: Carlos Molina

Generation: 2026-01-25T10:20:28.163Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
