# Cercles fractals

Voleu pintar en Python fractals tant xulos com aquest?

::: center
![image](6.eps){height="10cm"}
:::

Per pintar un fractal de $n\ge1$ nivells de mida $d$, cal pintar un
cercle de mida $d$, i quatre fractals al seu damunt, avall, esquerra i
dreta amb $n-1$ nivells i mida $d/2$. Un fractal de zero nivells és
buit.

Per exemple, aquests són els fractals amb 1, 2, 3, 4, 5 i 6 nivells:

::: center
1      

4      
:::

## Entrada

A l'entrada, es dónen dos valors: un natural $n$ amb el nombre de
nivells del fractal i un real positiu $d$ amb la seva mida.

## Sortida

El programa ha de dibuixar el fractal d'$n$ nivells i mida $d$ centrat a
la finestra.

::: multicols
2

## Exemple d'entrada 1

    4
    100

## Exemple de sortida 1
:::

::: multicols
2

## Exemple d'entrada 2

    2
    50

## Exemple de sortida 2
:::

## Recordatori

Recordeu que Python ofereix un mòdul `turtle` que permet pintar images.
Les úniques operacions que us calen són `turtle.goto(x, y)` que mou la
tortuga a les coordenades (`x`,`y`), `turtle.circle(r)` que pinta un
cercle de radi `r`, `turtle.down()` que activa el traçat i `turtle.up()`
que desactiva el traçat.

Per exemple, aquest programa pinta un cercle de mida `d` al mig de la
finestra:

::: small
    import turtle
    import yogi

    d = yogi.read(float)
    turtle.up()
    turtle.goto(0, -d/2)
    turtle.down()
    turtle.circle(d)
:::

## Important

Aquest problema no té jocs de proves al Jutge. Per tant, qualsevol
solució serà acceptada: semàfor verd! Això no vol dir que sigui bona ni
dolenta, el vostre professor ho corregirà.

## Informació del problema

Autoria: Jordi Petit

Generació: 2026-01-25T10:17:33.968Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
