# El agua de Vallcarca

En Vallcarca (que en catalán significa "Valle carca", aunque no se lo
recordéis a la gente que vive por allí) hace bastante bochorno por la
noche. Mis compañeros de piso y yo, que dormimos siempre de las 12 de la
noche a las 8 de la mañana, nos levantamos a menudo para beber agua de
la jarra que guardamos en la nevera. Después de muchos veranos de
práctica, sabemos exactamente en qué instantes de la noche se levanta
sediento cada uno de nosotros, y cuánta agua bebe. Después de beber,
siempre rellenamos del todo la jarra con agua del grifo. Esto hace que
suba la temperatura del agua de la jarra, por lo que la siguiente
persona en levantarse tal vez no beba su agua tan fría como sería
deseable.

Se te pide que descubras cuál es la mínima capacidad $C$ que debería
tener nuestra jarra para que ninguno de nosotros tenga que beber agua a
más de $10^\circ$ de temperatura.

La temperatura de la nevera es siempre $5^\circ$, que también es la
temperatura de los $C$ litros de agua en la jarra a las 12 de la noche.
La temperatura del agua del grifo es siempre $25^\circ$. Cuando se
mezcla agua del grifo con agua de la jarra, la temperatura del agua
resultante es el promedio ponderado de las temperaturas respectivas. O
sea, $$\begin{align*}
v &= v_j + v_g \\
t &= \frac{t_j \cdot v_j + 25 \cdot v_g}{v_j + v_g}
\end{align*}$$ donde $v$ y $t$ son el volumen y la temperatura del agua
resultante de mezclar $v_j$ litros de agua de la jarra a temperatura
$t_j$ con $v_g$ litros de agua del grifo. Por último, la nevera enfría
el agua a un ritmo de $0.1^\circ$ por minuto, sin importar lo grande que
sea la jarra.

## Entrada

Cada entrada contiene como mucho 100 casos de prueba. Cada caso se da en
tres líneas, con el número $k$ de veces que nos levantaremos a beber,
los $k$ instantes en los que lo haremos, separados por espacios y
ordenados de menor a mayor, y las $k$ cantidades de agua que beberemos
en cada instante. Puedes asumir $1\le k\le 20$, que todos los instantes
son distintos, y que cada cantidad bebida $b$ cumple $0 < b \le 1$.

## Salida

Para cada caso de entrada, tu programa deberá escribir una línea con la
mínima capacidad que necesita nuestra jarra, con exactamente dos
decimales de precisión.

## Puntuación

- **TestA:**   Resolver varias entradas con $k\le 2$.

<!-- -->

- **TestB:**   Resolver varias entradas con $k\le 20$.

## Información del problema

Autoría: Lander Ramos, Omer Giménez

Generación: 2026-01-25T10:16:45.225Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
