# P0004. Strobogrammatic numbers

Johnny, Roy and Steffy are studying for the final exams. While they are
taking a break, they have the following dialogue:

[Roy:]{.smallcaps}

:   Have you seen that sign on the wall? They have hanged it upside
    down!

[Johnny:]{.smallcaps}

:   You are right but, curiously, there is a number, 6180819, it is the
    same hanged right or upside down.

[Roy:]{.smallcaps}

:   It's true!

[Steffy:]{.smallcaps}

:   The numbers which have this property are called *strobogrammatic
    numbers*.

[Roy:]{.smallcaps}

:   What???

[Steffy:]{.smallcaps}

:   A natural number is called *strobogrammatic number* if it has the
    same value seen normally and upside down, taking into account that
    digits 0, 1 and 8 are symmetrical regarding to the horizontal axis,
    and that 6 and 9 are equal when are seen upside down.

[Johnny:]{.smallcaps}

:   The first 21 strobogrammatic numbers are 0, 1, 8, 11, 69, 88, 96,
    101, 111, 181, 609, 619, 689, 808, 818, 888, 906, 916, 986, 1001 and
    1111.

[Steffy:]{.smallcaps}

:   However, the numbers 12, 44 or 991 are not strobogrammatic numbers:
    the first two numbers can not be interpreted when they are upside
    down and the third one, read when it is upside down, represents 166.
    Notice that, excepting 0, any number ending in 0 is *not* an
    strobogrammatic number.

![image](1.png){width="4cm"} ![image](2.png){width="4cm"}

Your task is to write a program that indicates if several given natural
numbers are or are not strobogrammatic numbers, and counts how many of
the strobogrammatic numbers are odd numbers.

Your program must include and use the function

        bool is_strobogrammatic(int n);

that indicates if a natural number \|n\| is or is not an strobogrammatic
number.

## Input

The input is a sequence of natural numbers.

## Output

For each natural number of the input, print if it is an strobogrammatic
number or it is not. Afterwards, print an empty line and the number of
odd strobogrammatic numbers read. Follow the format of the instance.

## Problem information

Author: Unknown\
Translator: Carlos Molina

Generation: 2026-01-25T10:13:12.286Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
