# $50 \times 50 \ne 250$

In the ACM-ICPC World Finals 2012, the UPC team made as usual a nice set
of mistakes. One of them was the original assumption that
$50 \times 50 = 250$. Observe that this equation has two interesting
properties:

1.  The right-hand side of the equation is the result of removing one
    digit from the real result (in the example, 2500).

2.  At least one of the two numbers of the left-hand side of the
    equation has at least one digit such that, if removed, makes the
    equation correct (in the example, $5 \times 50 = 250$).

Let us call an equation $x \times y = z$ a *fail* when it fulfills
properties 1 and 2, and an *epic fail* when it only fulfills property 1.
For instance, $50 \times 50 = 200$ is an epic fail. Please write a
program to count the number of fails and epic fails that the UPC teams
can make at the ACM-ICPC World Finals. ( The real number is of course
$\infty$, but let us use the simplifications of the statement. )

## Input

Input consists of several cases. Every case has two numbers $x$ and $y$
with the same number of digits $n$. Those numbers can have leading
zeroes. Assume $2 \le n \le 1000$.

## Output

For every case, print the number of different fails and epic fails of
the kind $x \times y = z$. Note that $z$ must have length exactly
$2n - 1$, if necessary by adding leading zeroes.

## Problem information

Author: Salvador Roura

Generation: 2026-01-25T10:12:06.252Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
