# Solitaire game

There are thousands of solitaire card games. This problem describes one
more. Here, we will use the Spanish cards, where ranks are the numbers
from 1 to 9, plus the figures Sota (10), Caballo (11) and Rey (12), and
suits are Oros (golden coins), Copas (cups), Espadas (swords) and Bastos
(clubs).

We begin with a random permutation of the 48 cards. One by one, those
cards are placed face up on a table, from left to right. Every moment,
if there are three consecutive cards from left to right $x$, $y$ and $z$
such that $x$ and $z$ share the same rank or the same suit, then we say
that $x$ matches $z$, and $x$ is removed from the table. If there is
more than one such match, we always use the leftmost one. After all the
cards have been played, and all the matches applied, we win if there are
only two cards left. Note that, given the initial permutation of the
cards, this solitaire is deterministic. We cannot take any decision,
just follow the rules.

(The next page shows an example of the beginning of a game.)

What is the probability of winning this solitaire?

## Input

This problem has no input.

## Output

Print a line with the probability of winning a game, with five digits
after the decimal point, rounded as usual. For instance, if the
probability were $1/3$, you should print `0.33333`, if it were $2/3$,
you should print `0.66667`, and if it were $1\%$, you should print
`0.01000`.

We will denote ranks with the digits from 1 to 9, plus S, C and R, and
we will denote suits with O, C, E and B. Assume that the first cards are
CB, 1B, 1C, SO, 4B, 1E and 4O:

![image](CB.eps){width="2.0cm"} ![image](1B.eps){width="2.0cm"}
![image](1C.eps){width="2.0cm"} ![image](SO.eps){width="2.0cm"}
![image](4B.eps){width="2.0cm"} ![image](1E.eps){width="2.0cm"}
![image](4O.eps){width="2.0cm"}

The first match happens with 4B and 4O, so we remove 4B:

![image](CB.eps){width="2.0cm"} ![image](1B.eps){width="2.0cm"}
![image](1C.eps){width="2.0cm"} ![image](SO.eps){width="2.0cm"}
![image](1E.eps){width="2.0cm"} ![image](4O.eps){width="2.0cm"}

Now 1C matches 1E, and SO matches 4O. We apply the leftmost match and
remove 1C:

![image](CB.eps){width="2.0cm"} ![image](1B.eps){width="2.0cm"}
![image](SO.eps){width="2.0cm"} ![image](1E.eps){width="2.0cm"}
![image](4O.eps){width="2.0cm"}

Now the leftmost match is 1B with 1E, so we remove 1B:

![image](CB.eps){width="2.0cm"} ![image](SO.eps){width="2.0cm"}
![image](1E.eps){width="2.0cm"} ![image](4O.eps){width="2.0cm"}

The only match now is SO with 4O, so we remove SO:

![image](CB.eps){width="2.0cm"} ![image](1E.eps){width="2.0cm"}
![image](4O.eps){width="2.0cm"}

At this point there are no more matches left. So we would keep playings
new cards, and applying matches, etc.

## Problem information

Author: Salvador Roura

Generation: 2026-01-25T10:08:09.168Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
