# Base més petita amb el mateix nombre de dígits

Recordeu que en un sistema de numeració posicional, la base és el nombre
de dígits (símbols) diferents utilitzats per a representar els nombres.
Per exemple, en base 2, anomenat sistema de numeració binari, només
existeixen dos dígits: 0 i 1. En base 10, el sistema de numeració
decimal utilitzat habitualment, existeixen 10 dígits (del 0 al 9). També
es poden considerar bases superiors a 10, com per exemple el sistema
sexagesimal (emprat pels sumeris i pels babilonis) que usa base 60.

Donats dos nombres naturals, es vol trobar la base més petita (a partir
de dos) en la qual els dos nombres tenen el mateix nombre de dígits.
Observeu que aquesta base sempre existeix: agafeu el màxim, sumeu una
unitat, i la representació és d'un dígit en aquesta base.

Per a fer-ho, escriviu i useu una acció

            void base_amb_mateix_nombre_de_digits(int x, int y, int& b, int& n);

que, donats dos naturals $x$ i $y$, desi en $b$ quina és la base més
petita (amb $b\ge2$) en la qual $x$ i $y$ tenen el mateix nombre de
dígits, i desi en $n$ el nombre de dígits de $x$ i $y$ en aquesta base.

## Entrada

L'entrada conté diferents casos. Cada cas conté un parell de naturals,
tots dos són menors o iguals que $2\cdot10^9$.

## Sortida

Per a cada cas de l'entrada, la base més petita en la qual tenen el
mateix nombre de dígits i el nombre de dígits que tenen en aquesta base.

## Pista

Fixeu-vos que quan $x$ i $y$ són molt allunyats l'un de l'altre,
calcular els dígits de l'un i de l'altre en base $b$ i veure si
coïncideixen és lent.

## Observació

No podeu usar la biblioteca matemàtica per resoldre aquest problema.

## Informació del problema

Autoria: Jordi Cortadella

Generació: 2026-01-25T10:24:53.834Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
