# Day of the week

Write a function that, given a valid date made with a day \@d@, a month
\@m@ and a year \@y@, returns its day of the week, that is, "`Monday`",
or "`Tuesday`", or ...

To compute it, use the congruence of Zeller. Let $d$ be the day, $m$ be
the month, and $y$ be the year. Then,

1.  Subtract two from the month $m$, and if the result is zero or less,
    add 12 to the month and subtract one from the year. Call $m'$ the
    new month and call $y'$ the new year.

2.  Compute the century $c$ (the first two digits of the year) from the
    year $y'$.

3.  Compute the year $a$ inside the century (the two last digits of the
    year) from the year $y'$.

4.  Compute
    $$f = \lfloor 2.6m' - 0.2 \rfloor + d + a + \lfloor a/4 \rfloor
              + \lfloor c/4 \rfloor - 2c.$$

5.  Finally, $f$ modulo 7 gives us the desired result, taking into
    account that 0 represents Sunday, 1 represents Monday, 2 represents
    Tuesday, ..., and 6 represents Saturday.

## Interface

+--------:+:------------------------------------------------------------+
| C++     | ``` c++                                                     |
|         | string day_of_the_week (int d, int m, int y);               |
|         | ```                                                         |
+---------+-------------------------------------------------------------+
| C++     | ``` c                                                       |
|         | char* day_of_the_week (int d, int m, int y);                |
|         | ```                                                         |
+---------+-------------------------------------------------------------+
| Java    | ``` java                                                    |
|         | public static String day_of_the_week (int d, int m, int y); |
|         | ```                                                         |
+---------+-------------------------------------------------------------+
| Python  | ``` python                                                  |
|         | day_of_the_week (d, m, y)  # returns str                    |
|         | ```                                                         |
+---------+-------------------------------------------------------------+
|         | ``` python                                                  |
|         | day_of_the_week (d: int, m: int, y: int) -> str             |
|         | ```                                                         |
+---------+-------------------------------------------------------------+
| Haskell | ``` haskell                                                 |
|         | dayOfTheWeek :: Int -> Int -> Int -> String                 |
|         | ```                                                         |
+---------+-------------------------------------------------------------+

## Precondition

The parameter \@y@ is between 1800 and 9999, both included. The date is
valid.

## Hint

Watch out for modulos of negative numbers!

## Observation

You only need to submit the required procedure; your main program will
be ignored.

## Problem information

Author: Unknown\
Translator: Carlos Molina

Generation: 2026-01-25T10:22:10.737Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
