# Dia de la setmana

Feu una funció que, donada una data vàlida a través de tres enters que
corresponen al seu dia \@d@, al seu mes \@m@ i al seu any \@a@, retorni
el dia de la setmana en què cau, és a dir, "`dilluns`", o "`dimarts`", o
...

Per calcular-ho, useu la congruència de Zeller. Sigui $d$ el dia, $m$ el
mes i $a$ l'any. Llavors:

1.  Se li resta dos al mes $m$, i si dóna zero o menys se li suma 12 al
    mes i se li resta u a l'any. El nou mes obtingut l'anomenem $m'$ i
    el nou any $a'$.

2.  Es calcula la centúria $c$ (els dos primers dígits de l'any) a
    partir de l'any $a'$.

3.  Es calcula l'any $y$ dins de la centúria (els dos darrers dígits de
    l'any) a partir de l'any $a'$.

4.  Es calcula
    $$f = \lfloor 2.6m'-0.2 \rfloor + d + y + \lfloor y/4 \rfloor
              + \lfloor c/4 \rfloor - 2c.$$

5.  Finalment, $f$ mòdul 7 ens dóna el resultat desitjat: 0 representa
    diumenge, 1 representa dilluns, 2 representa dimarts, ...i 6
    representa dissabte.

## Interfície

+--------:+:--------------------------------------------------------------+
| C++     | ``` c++                                                       |
|         | string dia_de_la_setmana (int d, int m, int a);               |
|         | ```                                                           |
+---------+---------------------------------------------------------------+
| C       | ``` c                                                         |
|         | char* dia_de_la_setmana (int d, int m, int a);                |
|         | ```                                                           |
+---------+---------------------------------------------------------------+
| Java    | ``` java                                                      |
|         | public static String dia_de_la_setmana (int d, int m, int a); |
|         | ```                                                           |
+---------+---------------------------------------------------------------+
| Python  | ``` python                                                    |
|         | dia_de_la_setmana (d, m, a)  # returns str                    |
|         | ```                                                           |
+---------+---------------------------------------------------------------+
|         | ``` python                                                    |
|         | dia_de_la_setmana (d: int, m: int, a: int) -> str             |
|         | ```                                                           |
+---------+---------------------------------------------------------------+
| Haskell | ``` haskell                                                   |
|         | diaDeLaSetmana :: Int -> Int -> Int -> String                 |
|         | ```                                                           |
+---------+---------------------------------------------------------------+

## Precondició

El paràmetre corresponent a l'any està entre 1800 i 9999, ambdós
inclosos. La data és vàlida.

## Pista

Compte amb els mòduls de nombres negatius!

## Observació

Només cal enviar el procediment demanat; el programa principal serà
ignorat.

## Informació del problema

Autoria: Jordi Petit

Generació: 2026-01-25T10:22:16.358Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
