# The game of Nim

Consider the following variant of the two-player game of Nim, originated
in China: There are six sets numbered from 1 to 6, each one with $m_i$
marbles. Initially, we have $m_i = i$ for every $1 \le i \le 6$. In
turns, every player must choose one of the non-empty sets and remove at
least one of its marbles. The player that removes the last marble(s)
wins the game.

For instance, let Anne and Bill be the players. This is a possible
situation of the game after several turns (the first number denotes
$m_1$ and so on): $$1 \quad 1 \quad 0 \quad 0 \quad 5 \quad 0$$ If it is
Anne's turn, she may choose to remove the five marbles of the fifth set:
$$1 \quad 1 \quad 0 \quad 0 \quad 0 \quad 0$$ Next Bill has no real
option: he must remove one marble from any set (say the first one):
$$0 \quad 1 \quad 0 \quad 0 \quad 0 \quad 0$$ Now Anne can remove the
last marble, and therefore she wins the game. Note, if Anne had made any
other movement in the first place, she would had lost the game had Bill
played perfectly.

Write a program such that, given the names of the players (first the
player to play next) and the current number of marbles of every set,
prints the name of the player that wins the game, assuming perfect play
from both sides.

## Input

Input begins with the number of cases. Every case consists of the names
(only letters) of the players, followed by $m_1, \dots, m_6$. You can
assume $0 \le m_i \le i$ and $m_1 + \cdots + m_6 \ge 1$.

## Output

For every case, print its number, followed by the name of the winner
assuming perfect play.

## Problem information

Author: Salvador Roura

Generation: 2026-01-25T10:18:13.383Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
