# Dies de la setmana

Feu un programa que llegeixi una seqüència de dates, i escrigui per a
cadascuna d'elles el seu dia de la setmana corresponent, o indiqui que
la data no és correcta segons el calendari gregorià.

Implementeu les funcions

        bool es_any_de_traspas(int any);
        bool es_data_valida(int dia, int mes, int any);
        string dia_de_la_setmana(int dia, int mes, int any);    

Donat un any \@a@, \@es_any_de_traspas(a)@ indica si \@a@ és de traspàs
o no. Donada una data amb \@d@, \@m@ i \@a@, \@es_data_valida(d, m, a)@
indica si la data és vàlida o no segons el calendari gregorià. Donada
una data vàlida amb \@d@, \@m@ i \@a@, \@dia_de_la_setmana(d, m, a)@
retorna el dia de la setmana en què cau la data (és a dir, "\@Dilluns@",
"\@Dimarts@", ...).

Per saber el dia de la setmana, utilitzeu la *congruència de Zeller*:
Donada una data determinada pel triplet $(d,m,a)$, on $d$ és el dia del
mes, $m$ és el mes de l'any i $a$ és l'any,

1.  Se li resten dues unitat al mes $m$, i si dóna zero o menys se li
    suma 12 al mes i se li resta una unitat a l'any. El nou mes obtingut
    l'anomenem $m'$ i el nou any $a'$.

2.  Es calcula la centúria $c$ (els dos primers dígits de l'any) a
    partir de l'any $a'$.

3.  Es calcula l'any dins de la centúria $y$ (els dos darrers dígits de
    l'any) a partir de l'any $a'$.

4.  Es calcula
    $$f = \lfloor 2.6m'-0.2 \rfloor + d + y + \lfloor y/4 \rfloor
              + \lfloor c/4 \rfloor - 2c.$$

5.  Finalment, $f$ mòdul 7 ens dóna el resultat desitjat: 0 representa
    diumenge, 1 representa dilluns, 2 representa dimarts, \...

Podeu trobar la regla dels anys de traspàs a
l'exercici [**problem://problemsjutge.org:problems/p1/jpetit/traspas-elemental**](https://jutge.org/problems/problem://problems\@jutge.org:problems/p1/jpetit/traspas-elemental).

## Precondició

Per a les funcions \@es_any_de_traspas()@ i \@es_data_valida()@, el
valor de l'any sempre es troba entre 1800 i 9999 (ambdós inclosos). Per
a la funció \@dia_de_la_setmana()@, la data donada sempre és vàlida
segons la funció \@es_data_valida()@.

## Entrada

Cada data de l'entrada està formada per tres enters, corresponents
respectivament al dia, al més i a l'any. Tots els anys es troben entre
1800 i 9999.

## Sortida

Per a cada data de l'entrada, heu d'escriure en una línia el dia de la
setmana corresponent ("`Dilluns`", ..., "`Diumenge`") si aquesta és
correcta en el calendari gregorià, o bé "`Data Incorrecta`" si no ho és.

## Informació del problema

Autoria: Jordi Petit

Generació: 2026-01-25T10:11:43.868Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
