# P0017. Siracusa attacks again

Being $n$ a natural number greater than zero. Consider this algorithm:

- If $n = 1$, stop.

- If $n$ is an even number, divide it by 2.

- If $n$ is an odd number, multiply it by 3 and add 1.

For instance, starting with 6 we obtain
$6 \to 3 \to 10 \to 5 \to 16 \to 8 \to 4 \to 2 \to 1$.

The conjecture $3n + 1$ says that starting with any natural number
$n > 0$, it always arrives to 1. Although it has not still been proved,
using computers we know that is true for numbers
$n \le 4035225266123964416$.

Your task is to write a program that reads two natural numbers $m$ and
$p$ and prints which natural numbers between 1 and $m$ arrive to 1 in
$p$ or more steps. It must print also which is the greatest number
contained in their steps.

Your program must implement and use the procedure

        void converge(int n, int& k, int& far);

that, given an integer strictly positive \|n\|, stores at the parameter
\|k\| the number of steps that needs \|n\| to arrive to 1, and at the
parameter \|far\| the greatest number seen in the process. For instance,
\|converge(6, k, far);\| stores an 8 at \|k\| and a 16 at \|far\|.
Similarly, \|converge(4, k, far);\| stores a 2 at \|k\| and a 4 at
\|far\|, and \|converge(1, k, far);\| stores a 0 at \|k\| and an 1 at
\|far\|.

## Input

The input is two natural numbers $m$ and $p$, with $1 \le m \le 50000$.

## Output

Your program must print all the numbers between 1 and $m$ that arrive to
$1$ in $p$ or more steps, one per line. Besides, print also the greatest
produced number, following the format of the instances.

## Problem information

Author: Unknown\
Translator: Carlos Molina

Generation: 2026-01-25T10:09:34.159Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
