# Haskell --- Computations (1)

These problems are inspired in some of the problems from Project Euler.
You can find them at [https://projecteuler.net]{.sans-serif}.

- Write a function `sumMultiples35 :: Integer -> Integer` that, given a
  natural $n$, returns the sum of all mutiples of 3 or 5 below $n$.

- Write a function `fibonacci :: Int -> Integer` that, given a natural
  $n$, returns the $n$-th element of the Fibonacci sequence.

- Write a function `sumEvenFibonaccis :: Integer -> Integer` that, given
  a natural $n$, returns the sum of all even elements less than $n$ in
  the Fibonacci sequence.

- Write a function `largestPrimeFactor :: Int -> Int` that, given a
  natural $n\ge1$, returns the greatest prime factor of $n$.

- Write a function `isPalindromic :: Integer -> Bool` that, given a
  natural $n$, returns whether $n$ is palindromic, that is, if $n$ can
  be read in the same way from left to right than from right to left.

## Scoring

- **test-1a:**   Function *sumMultiples35* for $n\le 1000$.

<!-- -->

- **test-1b:**   Function *sumMultiples35* for big $n$.

<!-- -->

- **test-2a:**   Function *fibonacci* for $n\le 20$.

<!-- -->

- **test-2b:**   Function *fibonacci* for big $n$.

<!-- -->

- **test-3:**   Function *sumEvenFibonaccis*.

<!-- -->

- **test-4:**   Function *largestPrimeFactor*.

<!-- -->

- **test-5:**   Function *isPalindromic*.

## Problem information

Author: Unknown\
Translator: Jordi Petit

Generation: 2026-02-03T17:00:12.014Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
