# Approximation of e

The Taylor series of the function $e^{x}$ is $$e^{x}
= \sum_{i \ge 0} \frac{x^{i}}{i!}
\enspace .$$

Note that this series has an infinite number of terms. However, for any
$x$ we can get an approximation of $e^{x}$ by adding some of the first
terms of the series (of course, the more terms, the better the result).
In particular, chosing $x = 1$ gives us a method to compute
$e \simeq 2'71828182845904523536$: $$e = \sum_{i \ge 0} \frac{1}{i!}
\enspace .$$

Write a program that, for every given natural number $n$, prints the
approximation of $e$ that we get by adding the $n$ first terms of the
series above.

## Input

Input consists of several natural numbers $n$ between 0 and 20.

## Output

For every given $n$, print with 10 digits after the decimal point the
approximation of $e$ that we get by adding the $n$ first terms of the
series above.

## Observation

Because of overflow reasons, do all the computations for this exercise
using real numbers.

## Problem information

Author: Unknown\
Translator: Carlos Molina

Generation: 2026-01-25T10:00:47.619Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
