# Póker 

Pau Gargallo and his friends are in a hostel, deciding in which order
will start the classic winter race over the snow. Outside is really cold
and nobody wants to start.

--!'Decide it playing rock-paper-scissors! -- somebody proposes.

The suggestion is received with scepticism: !'the decision will take an
eternity, because there are more than a thousand runners! Pau intervenes
to propose a more sensible idea.

--By chance, here I have some hundreds decks of cards. We will play it
in a round of poker: I will deal five cards to everyone, and the
smallest hand will go out first, then the following one, etc.

--?'and in a event of a tie? -- proposes other person.

--If there was an improbable event of a tie --answers Pau-- those ones
that draw will go out according to the alphabetical order of their
names. That is, who appeared before in the dictionary, would go out to
run first.

Knowing the names and the cards of everyone of the friends of Pau,
?'would you be able to tell us in which order they will go out?

Below, we explain poker rules, as it is undestood in this problem.

**Explanation of the rules of poker**

A hand of poker is formed by 5 cards. We use the English deck the cards
are, from lowest to highest, the numbers from $2$ to $10$, $J$, $Q$,
$K$, and the ace $A$). There is not jokers. As there are various decks,
a hand can have many copies of the same card.

We say that two cards of the same number form a pair, three a trips,
four a quads and five a five of a kind. A straight is 5 consecutive
cards following the order $A-K-Q-J-10-9-8-7-6-5-4-3-2-A$ (the ace 'A'
can be the highest card and the lowest card of the straight $A-K-Q-J-10$
is the highest possible straight, and $5-4-3-2-A$ the lowest).

The hands are sorted out in the following way, from highest to lowest:

- Five of a kind.

- Straight flush (straight with all the cards of the same suit).

- Quads.

- Full house (a trips and a pair).

- Flush (all the cards of the same suit).

- Straight.

- Trips.

- Two pair.

- Pair.

- Nothing (the highest card).

If a hand is in many categories (for instance, a trips and a flush,
situation that can happen because we use various packs) the highest one
is considered the category of the hand (in the instance, the hand would
be a flush).

To break the tie between two hands of the same type, the next criterion
is used.:

- Straight: wins the straight with the highest card (not counting the
  case $5-4-3-2-A$, where 5 is considered the highest card and not the
  ace).

- Five of a kind, quads, trips, pair: wins the one that is formed by
  highest cards.

- Full house: wins the hand that has the most valuable trips. In a event
  of a tie, the most valuable pair.

- Two pair: wins the most valuable pair. In a event of a tie, wins who
  has the second most valuable pair.

If this criterion does not break the tie, then the values of all the
cards are compared. Wins who has the highest card. In a event of a tie,
the next one is compared, etc. Therefore, the only way that two hands
draw is that they have exactly cards with the same numbers.

## Input

In a line the number $n$ of friends of Pau (we assure you that Pau has
at least 2 friends but not more than 2500). Then, $n$ lines, each one of
them contains a word (the name of the friend, formed by uppercase and
lowercase letters, without spaces) and the $5$ cards that receives, also
separated by spaces. A card is a pair $N P$, where $N$ is the number of
the card ($2, 3, \ldots, 9, 10, J, Q, K, A$) and $P$ is the suit of the
card ($S$, $H$, $D$ or $C$).

All the friends have different names.

## Output

Your program must print, in $n$ lines, the numbers of the friends of
Pau, in the order that they will start the race.

## Hint

This problem is complicated, because is too easy to make some small
mistake writing the program.

## Problem information

Author: Unknown\
Translator: Carlos Molina

Generation: 2026-01-25T10:00:18.288Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
