# Optimal Matrix Multiplication

Given two matrices with dimensions $n_1 \times n_2$ and
$n_2 \times n_3$, the cost of the usual multiplication algorithm is
$\Theta(n_1 n_2 n_3)$. For simplicity, let us consider that the cost is
exactly $n_1 n_2 n_3$.

Suppose that we must compute $M_1 \times \dots \times M_m$, where every
$M_i$ is an $n_i \times n_{i+1}$ matrix. Since the product of matrices
is associative, we can choose the multiplication order. For example, to
compute $M_1 \times M_2 \times M_3 \times M_4$, we could either choose
$(M_1 \times M_2) \times (M_3 \times M_4)$, with cost
$n_1 n_2 n_3 + n_3 n_4 n_5 + n_1 n_3 n_5$, or either choose
$M_1 \times ((M_2 \times M_3) \times M_4)$, with cost
$n_2 n_3 n_4 + n_2 n_4 n_5 + n_1 n_2 n_5$, or three other possible
orders.

Write a program to find the minimum cost of computing
$M_1 \times \dots \times M_m$.

## Input

Input consists of several cases, each one with $m$ followed by the
$m + 1$ dimensions. Assume $2 \le m \le 100$ and $1 \le n_i \le 10^4$.

## Output

For every case, print the minimum cost to compute the product of the $m$
matrices.

## Problem information

Author: Unknown\
Translator: Salvador Roura

Generation: 2026-01-25T09:58:30.977Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
