# Multiplicació òptima de matrius

Donades dues matrius amb dimensions $n_1 \times n_2$ i $n_2 \times n_3$,
el cost de l'algorisme habitual per multiplicar-les és
$\Theta(n_1 n_2 n_3)$. Per senzillesa, considerem que el cost és
exactament $n_1 n_2 n_3$.

Suposem que hem de calcular $M_1 \times \dots \times M_m$, on cadascuna
de les $M_i$ és una matriu amb dimensions $n_i \times n_{i+1}$. Com que
el producte de matrius és associatiu, es pot triar en quin ordre es fan
les multiplicacions. Per exemple, per calcular
$M_1 \times M_2 \times M_3 \times M_4$, es podria fer
$(M_1 \times M_2) \times (M_3 \times M_4)$, amb cost
$n_1 n_2 n_3 + n_3 n_4 n_5 + n_1 n_3 n_5$, o bé
$M_1 \times ((M_2 \times M_3) \times M_4)$, amb cost
$n_2 n_3 n_4 + n_2 n_4 n_5 + n_1 n_2 n_5$, o bé tres altres ordres
possibles.

Feu un programa que trobi el cost mínim de calcular
$M_1 \times \dots \times M_m$.

## Entrada

L'entrada consisteix en diversos casos, cadascun amb $m$ seguit de les
$m + 1$ dimensions. Suposeu $2 \le m \le 100$ i $1 \le n_i \le 10^4$.

## Sortida

Per a cada cas, escriviu el cost mínim de calcular el producte de les
$m$ matrius.

## Informació del problema

Autoria: Salvador Roura

Generació: 2026-01-25T09:58:35.622Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
