#include "Player.hh"

using namespace std;


/**
 * Write the name of your player and save this file
 * with the same name and .cc extension.
 */
#define PLAYER_NAME Enric


const Dir DIRS[] = {Top, Bottom, Left, Right};
const Pos WRONG   = Pos(-1,-1);


struct PLAYER_NAME : public Player {


  /**
   * Factory: returns a new instance of this class.
   * Do not modify this function.
   */
  static Player* factory () {
    return new PLAYER_NAME;
  }
    

  /**
   * Attributes for your player can be defined here.
   */     

  int closest_goal(const Pos& p0, const set<Pos>& goals, Pos& next) {
    queue<Pos> q;
    q.push(p0);
    vector< vector<bool> > mrk(rows(), vector<bool>(cols(), false));
    mrk[p0.i][p0.j] = true;
    vector< vector<Pos > > par(rows(), vector<Pos >(cols()));
    par[p0.i][p0.j] = WRONG;
    while (not q.empty()) {
      Pos p = q.front();
      q.pop();
      if (goals.count(p) == 1) {
	Pos ant = p;
	Pos cur = p;
	int dist = 0;
	while (par[cur.i][cur.j] != WRONG) {
	  ant = cur;
	  cur = par[cur.i][cur.j];
	  ++dist;
	}
	next = ant;
	return dist;
      }
      for (int k = 0; k < 4; ++k) {
	Pos pp = dest(p, DIRS[k]);
	if (pos_ok(pp) and not mrk[pp.i][pp.j] and cell(pp).type != Rock) {
	  q.push(pp); 
	  mrk[pp.i][pp.j] = true;
	  par[pp.i][pp.j] = p;
	}
      }
    }
    next = WRONG;
    return maxint;
  }

  void find(set<Pos>& s, CType t) {
    for (int i = 0; i < rows(); ++i)
      for (int j = 0; j < cols(); ++j)
	if (cell(i,j).type == t)
	  s.insert(Pos(i,j));
  }

  void find_gokus_with_balls(set<Pos>& s) {
    for (int i = 0; i < rows(); ++i)
      for (int j = 0; j < cols(); ++j) {
	int id = cell(i,j).id;
	if (id != -1 and id != me() and has_ball(goku(id).type))
	  s.insert(Pos(i,j));
      }
  }

  void find_strong_gokus(set<Pos>& s) {
    for (int i = 0; i < rows(); ++i)
      for (int j = 0; j < cols(); ++j) {
	int id = cell(i,j).id;
	if (id != -1 and id != me() and goku(id).strength > goku(me()).strength)
	  s.insert(Pos(i,j));
      }
  }

  Dir find_direction(const Pos& ini, const Pos& fin) {
    if (fin.i == ini.i + 1  and fin.j == ini.j) return Bottom;
    if (fin.i == ini.i - 1  and fin.j == ini.j) return Top;
    if (fin.j == ini.j + 1  and fin.i == ini.i) return Right;
    if (fin.j == ini.j - 1  and fin.i == ini.i) return Left;
    return None;
  }

  bool go_to(const set<Pos>& s) {
    const Goku& g = goku(me());
    if (not s.empty()) {
      Pos next;
      int dist = closest_goal(g.pos, s, next);
      if (dist != maxint) {
	move( find_direction(g.pos, next) );
	return true;
      }
    }
    return false;
  }

  bool go_to(CType t) {
    set<Pos> s;
    find(s, t);
    return go_to(s);
  }

  /**
   * Play method.
   * 
   * This method will be invoked once per each round.
   * You have to read the board here to place your actions
   * for this round.
   *
   */     
  virtual void play () {

    const Goku& g = goku(me());

    set<Pos> s0;
    find_strong_gokus(s0);
    if (not s0.empty()) {
      Pos next;
      int dist = closest_goal(g.pos, s0, next);
      if (dist != maxint and dist <= 2) {
	Dir d = find_direction(g.pos, next);
	for (int k = 0; k < 4; ++k) {
	  if (DIRS[k] != d and cell(dest(g.pos, DIRS[k])).type != Rock) {
	    move(DIRS[k]);
	    return;
	  } 
	}
      }
    }
    if (has_ball(g.type))                  { go_to(Capsule); return; }
    if (not has_kinton(g.type))            { go_to(Kinton);  return; }
    if (g.strength < 10*moving_penalty())  { go_to(Bean);    return; }
    go_to(Ball);
  }

};


/**
 * Do not modify the following line.
 */
RegisterPlayer(PLAYER_NAME);

