#include <vector>
#include <queue>
#include <algorithm>
#include "Player.hh"

using namespace std;

/**
 * Write the name of your player and save this file
 * with the same name and .cc extension.
 */
#define PLAYER_NAME Millor





struct PLAYER_NAME : public Player {


    /**
     * Factory: returns a new instance of this class.
     * Do not modify this function.
     */
    static Player* factory () {
        return new PLAYER_NAME;
    }


    /**
     * Attributes for your player can be defined here.
     */

    typedef vector<int> VE;
    typedef vector<Dir> VD;
    typedef vector<VE> VVE;

    typedef queue<Pos>  QP;

    Pos add(Pos p, Dir d) {
      Pos q = p + d;
      if      (q.i < 0)       q.i = rows() - 1;
      else if (q.i >= rows()) q.i = 0;
      else if (q.j < 0)       q.j = cols() - 1;
      else if (q.j >= cols()) q.j = 0;
      return q;
    }

    void codi_comu(const VE& V, QP& Q, VVE& T) {

      if (Q.empty()) return;

      int s = 2;
      do {
        QP A;
        do {
          Pos q = Q.front(); 
	  Q.pop();
	  for (int dd = 1; dd <= 4; ++dd) {
	    Dir d = Dir(dd);
	    Pos p = add(q, d);
	    if (T[p.i][p.j] == 0) {
	      T[p.i][p.j] = s;
	      A.push(p);
	    }
	  }
        } while (not Q.empty());
        swap(Q, A);
        ++s;
      } while (not Q.empty());

      for (int k = 0; k < (int)V.size(); ++k) {
        Pos q = unit(V[k]).pos;
        int minim = maxint;
        VD D;
	for (int dd = 1; dd <= 4; ++dd) {
	  Dir d = Dir(dd);
	  Pos p = add(q, d);
	  int c = T[p.i][p.j];
	  if (c < minim) {
	    minim = c;
	    D = VD(1, d);
	  }
	  else if (c == minim)
	    D.push_back(d);
	}
        if (not D.empty()) {
          int z = random() % D.size();
          command(V[k], D[z]);
        }
      }
    }


    void mou_pagesos() {
      VVE T(rows(), VE(cols(), 0));
      QP Q;
      for (int i = 0; i < rows(); ++i)
        for (int j = 0; j < cols(); ++j) {
	  const Cell& c = cell(i, j);
          if (c.type == Wall or c.unit != -1)
	    T[i][j] = maxint;
          else if (c.owner != me()) {
	    T[i][j] = 1;
	    Q.push(Pos(i,j));
	  }
        }
      codi_comu(farmers(me()), Q, T);
    }

    void mou_cavallers() {
      VVE T(rows(), VE(cols(), 0));
      QP Q;
      for (int i = 0; i < rows(); ++i)
        for (int j = 0; j < cols(); ++j) {
	  const Cell& c = cell(i, j);
          if (c.type == Wall)
	    T[i][j] = maxint;
	  else if (c.unit != -1) {
	    if (unit(c.unit).player == me())
	      T[i][j] = maxint;
	    else {
	      T[i][j] = 1;
	      Q.push(Pos(i,j));
	    }
	  }
	}
      codi_comu(knights(me()), Q, T);
    }

    /**
     * Play method.
     *
     * This method will be invoked once per each round.
     * You have to read the board here to place your actions
     * for this round.
     *
     */
    virtual void play () {
      mou_pagesos();
      mou_cavallers();
    }


};


/**
 * Do not modify the following line.
 */
RegisterPlayer(PLAYER_NAME);

